#include "public.h"
#include <DallasTemperature.h>

// GPIO 訯定為 5
#define ONE_WIRE_BUS    5 
OneWire oneWire(ONE_WIRE_BUS); 
DallasTemperature sensors(&oneWire); 

void setup(){
  Serial.begin(115200);
  sensors.begin();
}

void loop(){
  Serial.println("開始設定溫度轉換");
  sensors.requestTemperatures();
  Serial.println("轉換完成");

  float tempC = sensors.getTempCByIndex(0); 
  if (tempC != DEVICE_DISCONNECTED_C)
  {
    Serial.print("現在溫度是： ");
    Serial.print(tempC);
    Serial.println(" ℃\n");
  }
  delay(2000);
}

